/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.ConstructorPair;
import org.jetbrains.kotlin.ir.backend.js.lower.SecondaryCtorLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.DescriptorsRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J \u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J \u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u00182\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/SecondaryConstructorLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "oldCtorToNewMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/ConstructorPair;", "generateFactoryBody", "", "constructor", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "stub", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "delegate", "generateInitBody", "generateStubsBody", "stubs", "lower", "transformConstructor", "", "ThisUsageReplaceTransformer", "backend.js"})
public final class SecondaryConstructorLowering
implements ClassLoweringPass {
    private final Map<IrConstructor, ConstructorPair> oldCtorToNewMap;
    @NotNull
    private final JsIrBackendContext context;

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        if (irClass.isInline()) {
            return;
        }
        List<IrDeclaration> $this$transformFlat$iv = irClass.getDeclarations();
        boolean $i$f$transformFlat = false;
        int i$iv = 0;
        while (i$iv < $this$transformFlat$iv.size()) {
            List<IrSimpleFunction> transformed$iv;
            IrDeclaration item$iv;
            IrDeclaration it = item$iv = $this$transformFlat$iv.get(i$iv);
            boolean bl = false;
            List<IrSimpleFunction> list2 = it instanceof IrConstructor ? (((IrConstructor)it).isPrimary() ? null : this.transformConstructor((IrConstructor)it, irClass)) : (transformed$iv = null);
            if (transformed$iv == null) {
                ++i$iv;
                continue;
            }
            $this$transformFlat$iv.addAll(i$iv, (Collection<IrDeclaration>)transformed$iv);
            $this$transformFlat$iv.remove(i$iv += transformed$iv.size());
        }
    }

    private final List<IrSimpleFunction> transformConstructor(IrConstructor constructor, IrClass irClass) {
        ConstructorPair constructorPair;
        Map<IrConstructor, ConstructorPair> $this$getOrPut$iv = this.oldCtorToNewMap;
        boolean $i$f$getOrPut = false;
        ConstructorPair value$iv = $this$getOrPut$iv.get(constructor);
        if (value$iv == null) {
            boolean bl = false;
            ConstructorPair answer$iv = SecondaryCtorLoweringKt.access$buildConstructorStubDeclarations(constructor, irClass);
            $this$getOrPut$iv.put(constructor, answer$iv);
            constructorPair = answer$iv;
        } else {
            constructorPair = value$iv;
        }
        ConstructorPair stubs = constructorPair;
        this.generateStubsBody(constructor, irClass, stubs);
        return CollectionsKt.listOf((Object[])new IrSimpleFunction[]{stubs.getDelegate(), stubs.getStub()});
    }

    private final void generateStubsBody(IrConstructor constructor, IrClass irClass, ConstructorPair stubs) {
        this.generateInitBody(constructor, irClass, stubs.getDelegate());
        this.generateFactoryBody(constructor, irClass, stubs.getStub(), stubs.getDelegate());
    }

    private final void generateFactoryBody(IrConstructor constructor, IrClass irClass, IrSimpleFunction stub, IrSimpleFunction delegate) {
        int i;
        IrSimpleType type2 = IrUtilsKt.getDefaultType(irClass);
        IrSimpleFunction createFunctionIntrinsic = this.context.getIntrinsics().getJsObjectCreate();
        IrCall irCreateCall = JsIrBuilder.INSTANCE.buildCall(createFunctionIntrinsic.getSymbol(), type2, CollectionsKt.listOf((Object)type2));
        IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, delegate.getSymbol(), type2, null, 4, null);
        boolean bl = false;
        boolean bl2 = false;
        IrCall call2 = irCall;
        boolean bl3 = false;
        int n = 0;
        int n2 = stub.getTypeParameters().size();
        while (n < n2) {
            call2.putTypeArgument(i, SecondaryCtorLoweringKt.access$toIrType(stub.getTypeParameters().get(i)));
            ++i;
        }
        n2 = stub.getValueParameters().size();
        for (i = 0; i < n2; ++i) {
            call2.putValueArgument(i, JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)stub.getValueParameters().get(i).getSymbol()));
        }
        call2.putValueArgument(constructor.getValueParameters().size(), irCreateCall);
        IrCall irDelegateCall = irCall;
        IrReturnImpl irReturn = JsIrBuilder.INSTANCE.buildReturn(stub.getSymbol(), irDelegateCall, this.context.getIrBuiltIns().getNothingType());
        stub.setBody(JsIrBuilder.INSTANCE.buildBlockBody(CollectionsKt.listOf((Object)irReturn)));
    }

    private final void generateInitBody(IrConstructor constructor, IrClass irClass, IrSimpleFunction delegate) {
        IrValueParameter thisParam = (IrValueParameter)CollectionsKt.last(delegate.getValueParameters());
        IrValueParameter irValueParameter = irClass.getThisReceiver();
        if (irValueParameter == null) {
            Intrinsics.throwNpe();
        }
        IrValueParameter oldThisReceiver = irValueParameter;
        IrReturnImpl retStmt = JsIrBuilder.INSTANCE.buildReturn(delegate.getSymbol(), JsIrBuilder.INSTANCE.buildGetValue((IrValueSymbol)thisParam.getSymbol()), this.context.getIrBuiltIns().getNothingType());
        IrBody irBody = constructor.getBody();
        if (irBody == null) {
            Intrinsics.throwNpe();
        }
        IrElement $this$deepCopyWithSymbols$iv = irBody;
        DescriptorsRemapper descriptorRemapper$iv = DescriptorsRemapper.DEFAULT.INSTANCE;
        boolean $i$f$deepCopyWithSymbols = false;
        DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(descriptorRemapper$iv);
        IrElementVisitorVoidKt.acceptVoid($this$deepCopyWithSymbols$iv, symbolRemapper$iv);
        DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
        IrElement irElement = PatchDeclarationParentsKt.patchDeclarationParents($this$deepCopyWithSymbols$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv, typeRemapper$iv, null, 4, null), null), delegate);
        if (irElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBody");
        }
        IrBody irBody2 = (IrBody)irElement;
        if (irBody2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrStatementContainer");
        }
        List<IrStatement> statements = ((IrStatementContainer)((Object)irBody2)).getStatements();
        List oldValueParameters = CollectionsKt.plus((Collection)constructor.getValueParameters(), (Object)oldThisReceiver);
        IrBlockBodyImpl irBlockBodyImpl = JsIrBuilder.INSTANCE.buildBlockBody(CollectionsKt.plus((Collection)statements, (Object)retStmt));
        IrSimpleFunction irSimpleFunction = delegate;
        boolean bl = false;
        boolean bl2 = false;
        IrBlockBodyImpl $this$apply = irBlockBodyImpl;
        boolean bl3 = false;
        IrElementTransformerVoidKt.transformChildrenVoid($this$apply, new ThisUsageReplaceTransformer(delegate.getSymbol(), MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)oldValueParameters, (Iterable)delegate.getValueParameters()))));
        IrBlockBodyImpl irBlockBodyImpl2 = irBlockBodyImpl;
        irSimpleFunction.setBody(irBlockBodyImpl2);
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public SecondaryConstructorLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.oldCtorToNewMap = this.context.getSecondaryConstructorToFactoryCache();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/SecondaryConstructorLowering$ThisUsageReplaceTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "function", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "symbolMapping", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "(Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;Ljava/util/Map;)V", "getFunction", "()Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "newThisSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "getNewThisSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "getSymbolMapping", "()Ljava/util/Map;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "expression", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "backend.js"})
    private static final class ThisUsageReplaceTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private final IrValueParameterSymbol newThisSymbol;
        @NotNull
        private final IrFunctionSymbol function;
        @NotNull
        private final Map<IrValueParameter, IrValueParameter> symbolMapping;

        @NotNull
        public final IrValueParameterSymbol getNewThisSymbol() {
            return this.newThisSymbol;
        }

        @Override
        @NotNull
        public IrExpression visitReturn(@NotNull IrReturn expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return new IrReturnImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), this.function, (IrExpression)new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), ((IrValueParameter)this.newThisSymbol.getOwner()).getType(), this.newThisSymbol, null, 16, null));
        }

        @Override
        @NotNull
        public IrGetValue visitGetValue(@NotNull IrGetValue expression2) {
            IrGetValue irGetValue;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Object object = this.symbolMapping;
            IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
            boolean bl = false;
            IrValueParameter irValueParameter = object.get(irValueDeclaration);
            if (irValueParameter != null) {
                object = irValueParameter;
                boolean bl2 = false;
                bl = false;
                Object it = object;
                boolean bl3 = false;
                IrGetValue irGetValue2 = expression2;
                boolean bl4 = false;
                boolean bl5 = false;
                IrGetValue $this$run = irGetValue2;
                boolean bl6 = false;
                irGetValue = new IrGetValueImpl($this$run.getStartOffset(), $this$run.getEndOffset(), $this$run.getType(), (IrValueSymbol)it.getSymbol(), $this$run.getOrigin());
            } else {
                irGetValue = expression2;
            }
            return irGetValue;
        }

        @NotNull
        public final IrFunctionSymbol getFunction() {
            return this.function;
        }

        @NotNull
        public final Map<IrValueParameter, IrValueParameter> getSymbolMapping() {
            return this.symbolMapping;
        }

        public ThisUsageReplaceTransformer(@NotNull IrFunctionSymbol function2, @NotNull Map<IrValueParameter, ? extends IrValueParameter> symbolMapping) {
            Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
            Intrinsics.checkParameterIsNotNull(symbolMapping, (String)"symbolMapping");
            this.function = function2;
            this.symbolMapping = symbolMapping;
            this.newThisSymbol = (IrValueParameterSymbol)((IrValueParameter)CollectionsKt.last((Iterable)this.symbolMapping.values())).getSymbol();
        }
    }
}

