/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.KParameterImpl;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer$WhenMappings;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017J\u001a\u0010\u0018\u001a\u00020\u0019*\u00060\u001aj\u0002`\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u0019*\u00060\u001aj\u0002`\u001b2\u0006\u0010\u001f\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lkotlin/reflect/jvm/internal/ReflectionObjectRenderer;", "", "()V", "renderer", "Lkotlin/reflect/jvm/internal/impl/renderer/DescriptorRenderer;", "renderCallable", "", "descriptor", "Lkotlin/reflect/jvm/internal/impl/descriptors/CallableDescriptor;", "renderFunction", "Lkotlin/reflect/jvm/internal/impl/descriptors/FunctionDescriptor;", "renderLambda", "invoke", "renderParameter", "parameter", "Lkotlin/reflect/jvm/internal/KParameterImpl;", "renderProperty", "Lkotlin/reflect/jvm/internal/impl/descriptors/PropertyDescriptor;", "renderType", "type", "Lkotlin/reflect/jvm/internal/impl/types/KotlinType;", "renderTypeParameter", "typeParameter", "Lkotlin/reflect/jvm/internal/impl/descriptors/TypeParameterDescriptor;", "appendReceiverType", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "receiver", "Lkotlin/reflect/jvm/internal/impl/descriptors/ReceiverParameterDescriptor;", "appendReceivers", "callable", "kotlin-reflect-api"})
public final class ReflectionObjectRenderer {
    private static final DescriptorRenderer renderer;
    public static final ReflectionObjectRenderer INSTANCE;

    private final void appendReceiverType(@NotNull StringBuilder $this$appendReceiverType, ReceiverParameterDescriptor receiver) {
        if (receiver != null) {
            KotlinType kotlinType = receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiver.type");
            $this$appendReceiverType.append(this.renderType(kotlinType));
            $this$appendReceiverType.append(".");
        }
    }

    private final void appendReceivers(@NotNull StringBuilder $this$appendReceivers, CallableDescriptor callable) {
        boolean addParentheses;
        ReceiverParameterDescriptor dispatchReceiver = UtilKt.getInstanceReceiverParameter(callable);
        ReceiverParameterDescriptor extensionReceiver = callable.getExtensionReceiverParameter();
        this.appendReceiverType($this$appendReceivers, dispatchReceiver);
        boolean bl = addParentheses = dispatchReceiver != null && extensionReceiver != null;
        if (addParentheses) {
            $this$appendReceivers.append("(");
        }
        this.appendReceiverType($this$appendReceivers, extensionReceiver);
        if (addParentheses) {
            $this$appendReceivers.append(")");
        }
    }

    private final String renderCallable(CallableDescriptor descriptor2) {
        String string;
        CallableDescriptor callableDescriptor = descriptor2;
        if (callableDescriptor instanceof PropertyDescriptor) {
            string = this.renderProperty((PropertyDescriptor)descriptor2);
        } else if (callableDescriptor instanceof FunctionDescriptor) {
            string = this.renderFunction((FunctionDescriptor)descriptor2);
        } else {
            String string2 = "Illegal callable: " + descriptor2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    @NotNull
    public final String renderProperty(@NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append(descriptor2.isVar() ? "var " : "val ");
        INSTANCE.appendReceivers($this$buildString, descriptor2);
        Name name = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"descriptor.name");
        $this$buildString.append(renderer.renderName(name, true));
        $this$buildString.append(": ");
        KotlinType kotlinType = descriptor2.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"descriptor.type");
        $this$buildString.append(INSTANCE.renderType(kotlinType));
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String renderFunction(@NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append("fun ");
        INSTANCE.appendReceivers($this$buildString, descriptor2);
        Name name = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"descriptor.name");
        $this$buildString.append(renderer.renderName(name, true));
        List<ValueParameterDescriptor> list = descriptor2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"descriptor.valueParameters");
        CollectionsKt.joinTo$default((Iterable)list, (Appendable)$this$buildString, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)renderFunction.1.1.INSTANCE, (int)48, null);
        $this$buildString.append(": ");
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"descriptor.returnType!!");
        $this$buildString.append(INSTANCE.renderType(kotlinType));
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String renderLambda(@NotNull FunctionDescriptor invoke) {
        Intrinsics.checkParameterIsNotNull((Object)invoke, (String)"invoke");
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        INSTANCE.appendReceivers($this$buildString, invoke);
        List<ValueParameterDescriptor> list = invoke.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"invoke.valueParameters");
        CollectionsKt.joinTo$default((Iterable)list, (Appendable)$this$buildString, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)renderLambda.1.1.INSTANCE, (int)48, null);
        $this$buildString.append(" -> ");
        KotlinType kotlinType = invoke.getReturnType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"invoke.returnType!!");
        $this$buildString.append(INSTANCE.renderType(kotlinType));
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String renderParameter(@NotNull KParameterImpl parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        switch (ReflectionObjectRenderer$WhenMappings.$EnumSwitchMapping$0[parameter.getKind().ordinal()]) {
            case 1: {
                $this$buildString.append("extension receiver");
                break;
            }
            case 2: {
                $this$buildString.append("instance");
                break;
            }
            case 3: {
                $this$buildString.append("parameter #" + parameter.getIndex() + ' ' + parameter.getName());
            }
        }
        $this$buildString.append(" of ");
        $this$buildString.append(INSTANCE.renderCallable(parameter.getCallable().getDescriptor()));
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String renderTypeParameter(@NotNull TypeParameterDescriptor typeParameter) {
        Intrinsics.checkParameterIsNotNull((Object)typeParameter, (String)"typeParameter");
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        switch (ReflectionObjectRenderer$WhenMappings.$EnumSwitchMapping$1[typeParameter.getVariance().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                $this$buildString.append("in ");
                break;
            }
            case 3: {
                $this$buildString.append("out ");
            }
        }
        $this$buildString.append(typeParameter.getName());
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String renderType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return renderer.renderType(type2);
    }

    private ReflectionObjectRenderer() {
    }

    static {
        ReflectionObjectRenderer reflectionObjectRenderer;
        INSTANCE = reflectionObjectRenderer = new ReflectionObjectRenderer();
        renderer = DescriptorRenderer.FQ_NAMES_IN_TYPES;
    }
}

