/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilationInitializer;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalResultStoringCompiler;
import org.gradle.api.internal.tasks.compile.incremental.SelectiveCompiler;
import org.gradle.api.internal.tasks.compile.incremental.cache.TaskScopedCompileCaches;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshotMaker;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilationData;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilationOutputAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpecProvider;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.language.base.internal.compile.Compiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalCompilerDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalCompilerDecorator.class);
    private final ClasspathSnapshotMaker classpathSnapshotMaker;
    private final TaskScopedCompileCaches compileCaches;
    private final CleaningJavaCompiler cleaningCompiler;
    private final RecompilationSpecProvider staleClassDetector;
    private final CompilationSourceDirs sourceDirs;
    private final Compiler<JavaCompileSpec> rebuildAllCompiler;
    private final IncrementalCompilationInitializer compilationInitializer;
    private final PreviousCompilationOutputAnalyzer previousCompilationOutputAnalyzer;
    private StringInterner interner;

    public IncrementalCompilerDecorator(ClasspathSnapshotMaker classpathSnapshotMaker, TaskScopedCompileCaches compileCaches, IncrementalCompilationInitializer compilationInitializer, CleaningJavaCompiler cleaningCompiler, RecompilationSpecProvider staleClassDetector, CompilationSourceDirs sourceDirs, Compiler<JavaCompileSpec> rebuildAllCompiler, PreviousCompilationOutputAnalyzer previousCompilationOutputAnalyzer, StringInterner interner) {
        this.classpathSnapshotMaker = classpathSnapshotMaker;
        this.compileCaches = compileCaches;
        this.compilationInitializer = compilationInitializer;
        this.cleaningCompiler = cleaningCompiler;
        this.staleClassDetector = staleClassDetector;
        this.sourceDirs = sourceDirs;
        this.rebuildAllCompiler = rebuildAllCompiler;
        this.previousCompilationOutputAnalyzer = previousCompilationOutputAnalyzer;
        this.interner = interner;
    }

    public Compiler<JavaCompileSpec> prepareCompiler(IncrementalTaskInputs inputs) {
        Compiler<JavaCompileSpec> compiler = this.getCompiler(inputs, this.sourceDirs);
        return new IncrementalResultStoringCompiler(compiler, this.classpathSnapshotMaker, this.compileCaches.getPreviousCompilationStore(), this.interner);
    }

    private Compiler<JavaCompileSpec> getCompiler(IncrementalTaskInputs inputs, CompilationSourceDirs sourceDirs) {
        if (!inputs.isIncremental()) {
            LOG.info("Full recompilation is required because no incremental change information is available. This is usually caused by clean builds or changing compiler arguments.");
            return this.rebuildAllCompiler;
        }
        if (!sourceDirs.canInferSourceRoots()) {
            LOG.info("Full recompilation is required because the source roots could not be inferred.");
            return this.rebuildAllCompiler;
        }
        PreviousCompilationData data = this.compileCaches.getPreviousCompilationStore().get();
        if (data == null) {
            LOG.info("Full recompilation is required because no previous compilation result is available.");
            return this.rebuildAllCompiler;
        }
        PreviousCompilation previousCompilation = new PreviousCompilation(data, this.compileCaches.getClasspathEntrySnapshotCache(), this.previousCompilationOutputAnalyzer);
        return new SelectiveCompiler(inputs, previousCompilation, this.cleaningCompiler, this.rebuildAllCompiler, this.staleClassDetector, this.compilationInitializer, this.classpathSnapshotMaker);
    }
}

