/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.internal.Pair;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.AbstractMapSnapshot;
import org.gradle.internal.snapshot.impl.MapValueSnapshot;

class IsolatedMap
extends AbstractMapSnapshot<Isolatable<?>>
implements Isolatable<Map<Object, Object>> {
    public IsolatedMap(ImmutableList<Pair<Isolatable<?>, Isolatable<?>>> entries) {
        super(entries);
    }

    @Override
    public ValueSnapshot asSnapshot() {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.entries.size());
        for (Pair entry : this.entries) {
            builder.add((Object)Pair.of((Object)((Isolatable)entry.left).asSnapshot(), (Object)((Isolatable)entry.right).asSnapshot()));
        }
        return new MapValueSnapshot((ImmutableList<Pair<ValueSnapshot, ValueSnapshot>>)builder.build());
    }

    @Override
    public Map<Object, Object> isolate() {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(this.getEntries().size());
        for (Pair entry : this.getEntries()) {
            map.put(((Isolatable)entry.left).isolate(), ((Isolatable)entry.right).isolate());
        }
        return map;
    }

    @Override
    @Nullable
    public <S> S coerce(Class<S> type) {
        return null;
    }
}

