/*
 * Decompiled with CFR 0.152.
 */
package cellframe.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class NativeLibraryLoader {
    private static final String NATIVE_FOLDER = "/native/";
    private static boolean loaded = false;
    private static final List<File> tempFiles = new ArrayList<File>();

    private static boolean isAndroidEnvironment() {
        try {
            Class.forName("android.os.Build");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static String getPlatform() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("mac")) {
            return "darwin";
        }
        if (os.contains("linux")) {
            return "linux";
        }
        if (os.contains("windows")) {
            return "windows";
        }
        throw new RuntimeException("Unsupported operating system: " + os);
    }

    public static void loadNativeLibraries() {
        if (loaded) {
            return;
        }
        if (NativeLibraryLoader.isAndroidEnvironment()) {
            System.out.println("Detected Android environment. Using System.loadLibrary.");
            try {
                System.loadLibrary("dap_wallet");
                loaded = true;
                System.out.println("Native library dap_wallet loaded successfully via System.loadLibrary.");
                return;
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println("Failed to load native library dap_wallet via System.loadLibrary: " + e.getMessage());
                throw new RuntimeException("Failed to load native library on Android", e);
            }
        }
        try {
            String platform = NativeLibraryLoader.getPlatform();
            String arch = System.getProperty("os.arch").toLowerCase();
            System.out.println("Loading native libraries for platform: " + platform + ", arch: " + arch);
            Path tempDir = Files.createTempDirectory("native-libs", new FileAttribute[0]);
            tempDir.toFile().deleteOnExit();
            System.out.println("Created temporary directory: " + tempDir);
            String nativePath = NATIVE_FOLDER + platform + "/" + arch;
            System.out.println("Looking for libraries in: " + nativePath);
            String extension = "";
            if (platform.equals("darwin")) {
                extension = "dylib";
            } else if (platform.equals("linux")) {
                extension = "so";
            } else if (platform.equals("windows")) {
                extension = "dll";
            }
            String jniLibrary = "libdap_wallet." + platform + "." + arch + "." + extension;
            System.out.println("Attempting to load JNI library: " + jniLibrary + " from path: " + nativePath);
            try {
                ClassLoader classLoader = NativeLibraryLoader.class.getClassLoader();
                InputStream resourceStream = classLoader.getResourceAsStream(nativePath.substring(1));
                System.out.println("Resource stream for directory: " + (resourceStream != null ? "found" : "not found"));
                InputStream rootStream = classLoader.getResourceAsStream("/");
                System.out.println("Root resource stream: " + (rootStream != null ? "found" : "not found"));
                InputStream directStream = classLoader.getResourceAsStream(nativePath + "/" + jniLibrary);
                System.out.println("Direct resource stream for library: " + (directStream != null ? "found" : "not found"));
            }
            catch (Exception e) {
                System.out.println("Error listing resources: " + e.getMessage());
                e.printStackTrace();
            }
            NativeLibraryLoader.loadLibrary(nativePath + "/" + jniLibrary, tempDir);
            List<String> libraries = NativeLibraryLoader.getResourceFiles(nativePath);
            System.out.println("Found additional libraries: " + libraries);
            for (String library : libraries) {
                if (!library.endsWith(".so") && !library.endsWith(".dylib") && !library.endsWith(".dll")) continue;
                System.out.println("Loading library: " + library);
                NativeLibraryLoader.loadLibrary(nativePath + "/" + library, tempDir);
            }
            loaded = true;
            System.out.println("All native libraries loaded successfully");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to load native libraries: " + e.getMessage(), e);
        }
    }

    private static void loadLibrary(String resourcePath, Path tempDir) throws IOException {
        System.out.println("Attempting to load library from: " + resourcePath);
        try (InputStream in = NativeLibraryLoader.class.getResourceAsStream(resourcePath);){
            if (in == null) {
                Object alternatePath = resourcePath;
                alternatePath = resourcePath.startsWith("/") ? resourcePath.substring(1) : "/" + resourcePath;
                System.out.println("Library not found, trying alternate path: " + (String)alternatePath);
                InputStream altIn = NativeLibraryLoader.class.getResourceAsStream((String)alternatePath);
                if (altIn == null) {
                    throw new RuntimeException("Cannot find native library: " + resourcePath + "\nAlso tried: " + (String)alternatePath + "\nPlease ensure the library is properly packaged in the jar under the native directory.");
                }
                System.out.println("Found library using alternate path");
                try (InputStream altStream = altIn;){
                    NativeLibraryLoader.extractAndLoadLibrary((String)alternatePath, altStream, tempDir);
                }
                return;
            }
            NativeLibraryLoader.extractAndLoadLibrary(resourcePath, in, tempDir);
        }
    }

    private static void extractAndLoadLibrary(String resourcePath, InputStream in, Path tempDir) throws IOException {
        String fileName = resourcePath.substring(resourcePath.lastIndexOf(47) + 1);
        File tempFile = new File(tempDir.toFile(), fileName);
        tempFiles.add(tempFile);
        tempFile.deleteOnExit();
        System.out.println("Extracting library to: " + tempFile.getAbsolutePath());
        try (FileOutputStream out = new FileOutputStream(tempFile);){
            int read;
            byte[] buffer = new byte[1024];
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        tempFile.setExecutable(true);
        System.out.println("Loading extracted library: " + tempFile.getAbsolutePath());
        try {
            System.load(tempFile.getAbsolutePath());
            System.out.println("Successfully loaded library: " + fileName);
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Failed to load native library: " + fileName);
            System.err.println("Error: " + e.getMessage());
            System.err.println("Library path: " + tempFile.getAbsolutePath());
            e.printStackTrace();
            throw new RuntimeException("Failed to load native library: " + fileName, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> getResourceFiles(String path) throws IOException {
        InputStream in;
        ArrayList<String> filenames = new ArrayList<String>();
        try {
            in = NativeLibraryLoader.class.getResourceAsStream(path);
            try {
                if (in != null) {
                    String[] files;
                    String[] object = files = new String(in.readAllBytes()).split("\\n");
                    int n = object.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            ArrayList<String> throwable = filenames;
                            return throwable;
                        }
                        String file = object[n2];
                        if (file.trim().length() > 0) {
                            filenames.add(file.trim());
                        }
                        ++n2;
                    }
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error listing resources with starting slash: " + e.getMessage());
        }
        if (!path.startsWith("/")) return filenames;
        try {
            in = NativeLibraryLoader.class.getResourceAsStream(path.substring(1));
            try {
                String[] files;
                if (in == null) return filenames;
                String[] stringArray = files = new String(in.readAllBytes()).split("\\n");
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String file = stringArray[n3];
                    if (file.trim().length() > 0) {
                        filenames.add(file.trim());
                    }
                    ++n3;
                }
                return filenames;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error listing resources without starting slash: " + e.getMessage());
        }
        return filenames;
    }

    public static void cleanup() {
        System.out.println("Cleaning up temporary files...");
        for (File file : tempFiles) {
            if (!file.exists()) continue;
            System.out.println("Deleting: " + file.getAbsolutePath());
            file.delete();
        }
        tempFiles.clear();
        System.out.println("Cleanup complete");
    }
}

