/*
 * Decompiled with CFR 0.152.
 */
package cellframe.crypto;

import cellframe.utils.NativeLibraryLoader;
import java.lang.ref.Cleaner;

public class EncKey {
    private static final Cleaner cleaner = Cleaner.create();
    private final long nativeHandle;
    private boolean isClosed;
    private final Cleaner.Cleanable cleanable;

    EncKey(long nativeHandle) {
        if (nativeHandle == 0L) {
            throw new IllegalArgumentException("Invalid native handle");
        }
        this.nativeHandle = nativeHandle;
        this.isClosed = false;
        this.cleanable = cleaner.register(this, new NativeResourceCleaner(nativeHandle));
    }

    public static EncKey fromNativeHandle(long nativeHandle) {
        return new EncKey(nativeHandle);
    }

    public long getNativeHandle() {
        return this.nativeHandle;
    }

    public static EncKey fromSeed(EncKeyType signType, String seed) {
        long nativeHandle = EncKey.createFromSeed(signType.getCode(), seed);
        return new EncKey(nativeHandle);
    }

    private static native void close(long var0);

    private static native int nativeGetType(long var0);

    private static native long createFromSeed(int var0, String var1);

    public EncKeyType getType() {
        return EncKeyType.fromCode(EncKey.nativeGetType(this.nativeHandle));
    }

    static {
        NativeLibraryLoader.loadNativeLibraries();
    }

    private static class NativeResourceCleaner
    implements Runnable {
        private final long nativeHandle;

        NativeResourceCleaner(long nativeHandle) {
            this.nativeHandle = nativeHandle;
        }

        @Override
        public void run() {
            if (this.nativeHandle != 0L) {
                EncKey.close(this.nativeHandle);
            }
        }
    }

    public static enum EncKeyType {
        INVALID(-1, "invalid"),
        NULL(0, "null"),
        IAES(0, "iaes"),
        OAES(1, "oaes"),
        BF_CBC(2, "bf_cbc"),
        BF_OFB(3, "bf_ofb"),
        GOST_OFB(4, "gost_ofb"),
        KUZN_OFB(5, "kuzn_ofb"),
        SALSA2012(6, "salsa2012"),
        SEED_OFB(7, "seed_ofb"),
        RLWE_NEWHOPE_CPA_KEM(8, "rlwe_newhope_cpa_kem"),
        MSRLN(11, "msrln"),
        RLWE_MSRLN16(12, "rlwe_msrln16"),
        RLWE_BCNS15(13, "rlwe_bcns15"),
        LWE_FRODO(14, "lwe_frodo"),
        CODE_MCBITS(15, "code_mcbits"),
        NTRU(16, "ntru"),
        MLWE_KYBER(17, "mlwe_kyber"),
        SIG_PICNIC(18, "sig_picnic"),
        SIG_BLISS(19, "sig_bliss"),
        SIG_TESLA(20, "sig_tesla"),
        SIG_DILITHIUM(21, "sig_dilithium"),
        SIG_RINGCT20(22, "sig_ringct20"),
        KEM_KYBER512(23, "kem_kyber512"),
        SIG_FALCON(24, "sig_falcon"),
        SIG_SPHINCSPLUS(25, "sig_sphincsplus"),
        SIG_ECDSA(26, "sig_ecdsa"),
        SIG_SHIPOVNIK(27, "sig_shipovnik"),
        SIG_MULTI_CHAINED(100, "sig_multi_chained"),
        PQLR_SIG_DILITHIUM(1021, "pqlr_sig_dilithium"),
        PQLR_SIG_FALCON(1024, "pqlr_sig_falcon"),
        PQLR_SIG_SPHINCS(1025, "pqlr_sig_sphincs"),
        PQLR_KEM_SABER(1051, "pqlr_kem_saber"),
        PQLR_KEM_MCELIECE(1052, "pqlr_kem_mceliece"),
        PQLR_KEM_NEWHOPE(1058, "pqlr_kem_newhope");

        private final int code;
        private final String value;

        private EncKeyType(int code, String value) {
            this.code = code;
            this.value = value;
        }

        public int getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public static EncKeyType fromCode(int code) {
            for (EncKeyType type : EncKeyType.values()) {
                if (type.code != code) continue;
                return type;
            }
            return INVALID;
        }

        public static EncKeyType fromString(String text) {
            for (EncKeyType type : EncKeyType.values()) {
                if (!type.value.equalsIgnoreCase(text)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown encryption key type: " + text);
        }
    }
}

