/*
 * Decompiled with CFR 0.152.
 */
package cellframe;

import cellframe.crypto.EncKey;
import cellframe.crypto.Signer;
import cellframe.datum.Tx;
import cellframe.wallet.NetID;
import cellframe.wallet.Wallet;
import cellframe.wallet.WalletAddress;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class SignTool {
    private static final String HELP_TEXT = "Usage: SignTool {-w, --wallet <path_to_wallet_file> | -z, --seed <seed_phrase> -s <sign_type>} [OPTIONS] | {-c -w <wallet_name> -d <path_to_save_wallet_file> -s <sign_type> -z <seed_phrase>} | {-a {-w <path_to_wallet_file> | -z, --seed <seed_phrase> -s <sign_type>} -i 0x<net_id>}\n\rSigns the datum passed to the input using specified wallet and sends its items in the json-format.\n\rDatum sign options:\n\r\t-w, --wallet     specifies path to the wallet for datum sign or wallet name\n\r\t-p, --password   specifies walled password if needed\n\r\t-f, --filename   specifies input json-file with datum items. If not specified, it will be received from stdin\n\r\t-o, --out        specifies output json-file. If not specified, it will be sent into stdout\n\r\t-b, --beauty     enables output JSON beautification\n\r\t-z, --seed       specifies the seed phrase\n\r\t-s, --sign-type  specifies wallet sign type. Available options: sig_dil, sig_falcon\n\r\t-x, --sha2       use sha256 hash function for seed hashing\n\r\n\r\t-c, --create     creates the wallet -w with password -p\n\rWallet creation options:\n\r\t-w, --wallet     specifies wallet name\n\r\t-d, --path       specifies path to save wallet file\n\r\t-s, --sign-type  specifies wallet sign type. Available options: sig_dil, sig_falcon\n\r\t-z, --seed       specifies the seed phrase\n\r\t-x, --sha2       use sha256 hash function for seed hashing\n\r\t-0, --version0   use legacy Dashboard-compatible hashing. Implies sha256 automatically\n\rWallet get address:\n\r\t-a, --get-addr   prints wallet address in the specified net\n\r\t-w, --wallet     specifies path to the wallet file\n\r\t-z, --seed       specifies the seed phrase\n\r\t-s, --sign-type  specifies wallet sign type. Available options: sig_dil, sig_falcon\n\r\t-x, --sha2       use sha256 hash function for seed hashing\n\r\t-0, --version0   use legacy Dashboard-compatible hashing. Implies sha256 automatically\n\r\t-i, --net-id     hex id of the net\n\r";

    private static Map<String, String> parseArgs(String[] args) {
        HashMap<String, String> options = new HashMap<String, String>();
        block48: for (int i = 0; i < args.length; ++i) {
            String arg;
            switch (arg = args[i]) {
                case "--version": {
                    options.put("version", "true");
                    continue block48;
                }
                case "-w": 
                case "--wallet": {
                    if (i + 1 >= args.length) continue block48;
                    options.put("wallet", args[++i]);
                    continue block48;
                }
                case "-p": 
                case "--password": {
                    if (i + 1 >= args.length) continue block48;
                    options.put("password", args[++i]);
                    continue block48;
                }
                case "-f": 
                case "--filename": {
                    if (i + 1 >= args.length) continue block48;
                    options.put("filename", args[++i]);
                    continue block48;
                }
                case "-o": 
                case "--out": {
                    if (i + 1 >= args.length) continue block48;
                    options.put("out", args[++i]);
                    continue block48;
                }
                case "-b": 
                case "--beauty": {
                    options.put("beauty", "true");
                    continue block48;
                }
                case "-z": 
                case "--seed": {
                    if (i + 1 >= args.length) continue block48;
                    options.put("seed", args[++i]);
                    continue block48;
                }
                case "-s": 
                case "--sign-type": {
                    if (i + 1 >= args.length) continue block48;
                    options.put("sign-type", args[++i]);
                    continue block48;
                }
                case "-x": 
                case "--sha2": {
                    options.put("sha2", "true");
                    continue block48;
                }
                case "-c": 
                case "--create": {
                    options.put("create", "true");
                    continue block48;
                }
                case "-d": 
                case "--path": {
                    if (i + 1 >= args.length) continue block48;
                    options.put("path", args[++i]);
                    continue block48;
                }
                case "-0": 
                case "--version0": {
                    options.put("version0", "true");
                    continue block48;
                }
                case "-a": 
                case "--get-addr": {
                    options.put("get-addr", "true");
                    continue block48;
                }
                case "-i": 
                case "--net-id": {
                    if (i + 1 >= args.length) continue block48;
                    options.put("net-id", args[++i]);
                    continue block48;
                }
                case "-h": 
                case "--help": {
                    options.put("help", "true");
                    continue block48;
                }
                default: {
                    System.err.println("Unknown option: " + arg);
                }
            }
        }
        return options;
    }

    private static void handleGetAddress(Map<String, String> options) {
        try {
            String walletPath = options.get("wallet");
            String netIdHex = options.get("net-id");
            if (walletPath == null || netIdHex == null) {
                System.err.println("Error: Wallet path and network ID are required for get-addr command");
                return;
            }
            Wallet wallet = Wallet.fromFile(new File(walletPath), options.get("password"));
            WalletAddress address = wallet.getAddress(NetID.fromHex(netIdHex));
            System.out.println("Address: " + address.toString());
        }
        catch (Exception e) {
            System.err.println("Error getting address: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void handleCreateWallet(Map<String, String> options) {
        try {
            String walletName = options.get("wallet");
            String walletPath = options.get("path");
            String seed = options.get("seed");
            String signTypeStr = options.get("sign-type") != null ? options.get("sign-type") : "sig_dil";
            String password = options.get("password");
            if (walletName == null || walletPath == null) {
                System.err.println("Error: Wallet name, path, and sign-type are required for wallet creation");
                return;
            }
            Wallet.WalletType signType = Wallet.WalletType.fromString(signTypeStr);
            Wallet wallet = Wallet.create(Paths.get(walletPath, new String[0]), walletName, signType, seed, password);
            System.out.println("Wallet created successfully: " + walletPath + walletName);
        }
        catch (Exception e) {
            System.err.println("Error creating wallet: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static String readInput(String filename) throws IOException {
        StringBuilder input = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(filename));){
            String line;
            while ((line = reader.readLine()) != null) {
                input.append(line);
            }
        }
        return input.toString();
    }

    private static String readInput(InputStream inputStream) throws IOException {
        StringBuilder input = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                input.append(line);
            }
        }
        return input.toString();
    }

    private static void writeOutput(String output, String filename) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filename));){
            writer.write(output);
        }
    }

    private static void handleSignData(Map<String, String> options) {
        try {
            String input;
            String netIdHex;
            String walletPath = options.get("wallet");
            String filename = options.get("filename") != null ? options.get("filename") : null;
            String out = options.get("out") != null ? options.get("out") : null;
            String password = options.get("password") != null ? options.get("password") : null;
            String signTypeStr = options.get("sign-type") != null ? options.get("sign-type") : "sig_dil";
            String seed = options.get("seed") != null ? options.get("seed") : null;
            String string = netIdHex = options.get("net-id") != null ? options.get("net-id") : null;
            if (walletPath == null && seed == null) {
                System.err.println("Error: wallet path or seed are required");
                return;
            }
            if (netIdHex == null) {
                System.err.println("Error: net id is required");
                return;
            }
            String string2 = input = filename != null ? SignTool.readInput(filename) : SignTool.readInput(System.in);
            if (input == null) {
                System.err.println("Error: input is required");
                return;
            }
            EncKey encKey = walletPath != null ? Wallet.fromFile(new File(walletPath), password).getEncKey() : EncKey.fromSeed(EncKey.EncKeyType.SIG_DILITHIUM, seed);
            Tx datumTx = Tx.fromJson(input);
            Signer signer = new Signer(encKey);
            Tx signedDatumTx = signer.signDatumTx(datumTx);
            if (out != null) {
                SignTool.writeOutput(signedDatumTx.toJson(), out);
            } else {
                System.out.println(signedDatumTx.toJson());
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Map<String, String> options;
        if (args.length == 0) {
            System.out.println(HELP_TEXT);
            System.exit(1);
        }
        if ((options = SignTool.parseArgs(args)).containsKey("version")) {
            System.out.println("1.0-0");
            System.exit(0);
        }
        if (options.containsKey("help")) {
            System.out.println(HELP_TEXT);
            System.exit(0);
        }
        if (options.containsKey("get-addr")) {
            SignTool.handleGetAddress(options);
        } else if (options.containsKey("create")) {
            SignTool.handleCreateWallet(options);
        } else if (options.containsKey("wallet") || options.containsKey("seed")) {
            SignTool.handleSignData(options);
        } else {
            System.out.println(HELP_TEXT);
            System.exit(1);
        }
    }
}

