/*
 * Decompiled with CFR 0.152.
 */
package cellframe.wallet;

import cellframe.utils.NativeLibraryLoader;
import cellframe.wallet.NetID;
import java.lang.ref.Cleaner;

public class WalletAddress {
    private static final Cleaner cleaner = Cleaner.create();
    private final long nativeHandle;
    private final NetID netId;
    private boolean isClosed;
    private final Cleaner.Cleanable cleanable;

    WalletAddress(long nativeHandle, NetID netId) {
        if (nativeHandle == 0L) {
            throw new IllegalArgumentException("Invalid native handle");
        }
        this.nativeHandle = nativeHandle;
        this.isClosed = false;
        this.netId = netId;
        this.cleanable = cleaner.register(this, new NativeResourceCleaner(nativeHandle));
    }

    private static native void close(long var0);

    private static native String toStringNative(long var0);

    public String toString() {
        return WalletAddress.toStringNative(this.nativeHandle);
    }

    static {
        NativeLibraryLoader.loadNativeLibraries();
    }

    private static class NativeResourceCleaner
    implements Runnable {
        private final long nativeHandle;

        NativeResourceCleaner(long nativeHandle) {
            this.nativeHandle = nativeHandle;
        }

        @Override
        public void run() {
            if (this.nativeHandle != 0L) {
                WalletAddress.close(this.nativeHandle);
            }
        }
    }
}

