/*
 * Decompiled with CFR 0.152.
 */
package cellframe.wallet;

import cellframe.crypto.EncKey;
import cellframe.utils.NativeLibraryLoader;
import cellframe.wallet.NetID;
import cellframe.wallet.WalletAddress;
import java.io.File;
import java.lang.ref.Cleaner;
import java.nio.file.Path;

public class Wallet {
    private static final Cleaner cleaner = Cleaner.create();
    private final long nativeHandle;
    private boolean isClosed;
    private final Cleaner.Cleanable cleanable;

    private static native long openFile(String var0, String var1, int[] var2);

    private static native void close(long var0);

    private static native int getCertsNumber(long var0);

    private static native long getAddress(long var0, long var2);

    private static native long createNative(String var0, String var1, String var2, String var3, String var4, boolean var5, boolean var6);

    private static native long getEncKey(long var0);

    private Wallet(long nativeHandle) {
        this.nativeHandle = nativeHandle;
        this.isClosed = false;
        this.cleanable = cleaner.register(this, new NativeResourceCleaner(nativeHandle));
    }

    public static Wallet fromFile(File file) {
        return Wallet.fromFile(file, null);
    }

    public static Wallet fromFile(File file, String password) {
        int[] outStat = new int[1];
        long handle = Wallet.openFile(file.getAbsolutePath(), password, outStat);
        if (handle == 0L) {
            throw new RuntimeException("Failed to open wallet file: " + file.getAbsolutePath() + " " + outStat[0]);
        }
        return new Wallet(handle);
    }

    public static Wallet create(Path path, String name, WalletType signType, String password, String seed) {
        long handle = Wallet.createNative(path.toAbsolutePath().toString(), name, signType.getValue(), seed, password, false, false);
        if (handle == 0L) {
            throw new RuntimeException("Failed to create wallet from seed ");
        }
        return new Wallet(handle);
    }

    public static Wallet create(Path path, String name, WalletType signType) {
        return Wallet.create(path, name, signType, null, null);
    }

    public static Wallet create(Path path, String name, WalletType signType, String password) {
        return Wallet.create(path, name, signType, password, null);
    }

    public WalletAddress getAddress(NetID netId) {
        if (this.isClosed) {
            throw new IllegalStateException("Wallet is closed");
        }
        long addressHandle = Wallet.getAddress(this.nativeHandle, netId.getNativeNetId());
        if (addressHandle == 0L) {
            throw new RuntimeException("Failed to get wallet address for network ID: " + netId);
        }
        return new WalletAddress(addressHandle, netId);
    }

    public int getCertsNumber() {
        if (this.isClosed) {
            throw new IllegalStateException("Wallet is closed");
        }
        return Wallet.getCertsNumber(this.nativeHandle);
    }

    public EncKey getEncKey() {
        if (this.isClosed) {
            throw new IllegalStateException("Wallet is closed");
        }
        long encKeyHandle = Wallet.getEncKey(this.nativeHandle);
        if (encKeyHandle == 0L) {
            throw new RuntimeException("Failed to get encryption key");
        }
        return EncKey.fromNativeHandle(encKeyHandle);
    }

    static {
        NativeLibraryLoader.loadNativeLibraries();
    }

    private static class NativeResourceCleaner
    implements Runnable {
        private final long nativeHandle;

        NativeResourceCleaner(long nativeHandle) {
            this.nativeHandle = nativeHandle;
        }

        @Override
        public void run() {
            if (this.nativeHandle != 0L) {
                Wallet.close(this.nativeHandle);
            }
        }
    }

    public static enum WalletType {
        SIG_DIL("sig_dil"),
        SIG_FALCON("sig_falcon");

        private final String value;

        private WalletType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static WalletType fromString(String text) {
            for (WalletType type : WalletType.values()) {
                if (!type.value.equalsIgnoreCase(text)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown wallet type: " + text);
        }
    }
}

