# Cellframe Node API Testing Integration

Этот документ описывает интеграцию CLI клиента в пайплайн сборки Cellframe Node для автоматического тестирования API и обратной совместимости.

## 🎯 Цель

Автоматически проверять корректность API ответов ноды после каждой сборки, обеспечивая:
- ✅ Обратную совместимость с API v1 и v2
- ✅ Корректность JSON схем ответов
- ✅ Валидацию всех основных API методов
- ✅ Быстрое обнаружение breaking changes

## 📋 Компоненты системы

### 1. `test_node.py` - Основной тестировщик
- Автоматически тестирует все доступные API методы
- Поддерживает обе версии API (v1 и v2)
- Валидирует ответы против JSON схем
- Генерирует подробные отчеты

### 2. `install_and_test.sh` - Скрипт интеграции
- Устанавливает ноду из .deb пакета
- Настраивает Python окружение
- Запускает ноду и ждет готовности
- Выполняет тесты и возвращает код выхода

### 3. `.gitlab-ci.yml` - CI/CD интеграция
- Создает архив клиента
- Предоставляет готовую джобу для интеграции

## 🔧 Интеграция в пайплайн ноды

### Шаг 1: Добавить джобу в пайплайн ноды

Добавьте следующую джобу в `.gitlab-ci.yml` проекта ноды:

\`\`\`yaml
variables:
  CLI_CLIENT_VERSION: "1.0.0"
  CLI_CLIENT_URL: "https://pub.cellframe.net/linux/cellframe-node-cli/master/cellframe-node-cli-\${CLI_CLIENT_VERSION}.zip"

stages:
  - build
  - test_api
  - package

api_validation:
  stage: test_api
  image: demlabs/debian/amd64:java11
  dependencies:
    - your_node_build_job  # Замените на имя вашей джобы сборки ноды
  before_script:
    - apt-get update && apt-get install -y python3 python3-pip python3-venv curl jq unzip wget
    - wget \${CLI_CLIENT_URL} -O cellframe-node-cli.zip
    - unzip cellframe-node-cli.zip -d cli/
    - cd cli/
  script:
    - cp ../build/cellframe-node-*.deb ./cellframe-node-latest.deb
    - chmod +x install_and_test.sh
    - ./install_and_test.sh cellframe-node-latest.deb
  artifacts:
    when: always
    paths:
      - cli/test_results/
    reports:
      junit: cli/test_results/test_report_*.json
    expire_in: 1 week
  allow_failure: false
\`\`\`

### Шаг 2: Настройка зависимостей

Убедитесь, что джоба тестирования зависит от джобы сборки ноды:
- `dependencies:` должен указывать на джобу, которая создает .deb пакет ноды
- Путь к артефакту ноды должен соответствовать вашей структуре

### Шаг 3: Проверка схем

Убедитесь, что все схемы в `schemas/` актуальны:
- `schemas/v1/` - схемы для API версии 1
- `schemas/v2/` - схемы для API версии 2

## 📊 Результаты тестирования

### Структура отчета
\`\`\`json
{
  "v1": {
    "version": {"status": "PASS", "validation": true},
    "net_list": {"status": "PASS", "validation": true}
  },
  "v2": {
    "version": {"status": "PASS", "validation": true},
    "net_list": {"status": "PASS", "validation": true}
  },
  "summary": {
    "total_tests": 10,
    "passed": 8,
    "failed": 1,
    "errors": 1,
    "success_rate": "80.0%"
  }
}
\`\`\`

### Статусы тестов
- `PASS` - тест прошел успешно
- `FAIL` - ответ не соответствует схеме
- `ERROR` - ошибка выполнения запроса
- `NO_SCHEMA` - отсутствует схема для валидации

## 🚨 Обработка ошибок

### Критичные ошибки (пайплайн прерывается):
- Нода не запускается
- Нода не отвечает на запросы
- Критичные API методы возвращают неверный формат

### Некритичные ошибки (предупреждения):
- Отсутствие схемы для нового метода
- Неработающие кошелек-специфичные методы

## 🔄 Запуск вручную

### Локальное тестирование:
\`\`\`bash
# Установить зависимости
pip install -r requirements.txt

# Тестировать локальную ноду
python3 test_node.py

# Тестировать с установкой ноды
sudo ./install_and_test.sh cellframe-node-latest.deb

# Тестировать конкретный метод
python3 test_node.py --command version --version v1
\`\`\`

### Тестирование удаленной ноды:
\`\`\`bash
python3 test_node.py --node-url http://remote-node:12345/connect
\`\`\`

## 📈 Мониторинг и метрики

### GitLab интеграция:
- Результаты отображаются в GitLab UI
- Junit отчеты для детального анализа
- Артефакты сохраняются для анализа

### Метрики качества:
- Success Rate - процент успешных тестов
- API Coverage - покрытие API методов тестами
- Backward Compatibility - совместимость между версиями

## 🔧 Расширение тестов

### Добавление нового API метода:
1. Создать шаблон запроса в `requests/new_method.json`
2. Создать схему в `schemas/v1/new_method.schema.json`
3. При необходимости обновить `test_node.py`

### Добавление новой версии API:
1. Создать директорию `schemas/v3/`
2. Обновить `test_node.py` для поддержки v3
3. Добавить тесты в пайплайн

## 📞 Поддержка

При проблемах с интеграцией:
1. Проверьте логи тестирования в артефактах GitLab
2. Убедитесь в корректности схем JSON
3. Проверьте доступность ноды на указанном URL
4. Обратитесь к команде разработки CLI клиента
