# Cellframe Node CLI

CLI инструмент для взаимодействия с нодами Cellframe Network через JSON RPC.

## Установка

```bash
pip install -r requirements.txt
```

## Пример использования

### Отправить запрос на локальную ноду:
```bash
python3 main/client.py send --request wallet_outputs --arg net KelVPN --arg w main_1 --arg token KEL
```

### Отправить на RPC + v2 + валидация:
```bash
python3 main/client.py send --request wallet_outputs --v2 --target rpc --arg net KelVPN --arg addr ... --arg token KEL --validate --schema wallet_schema.json --schema-version v2
```

### Валидация отдельно:
```bash
python3 main/client.py validate --response wallet_outputs_20250711_153000.json --schema wallet_schema.json --schema-version v2
```

## Новые команды

### Статистика CPU ноды:
```bash
python3 main/client.py send --request node_stats --validate --schema node_stats.schema.json --schema-version v1
```

### Поиск кошелька по адресу:
```bash
python3 main/client.py send --request wallet_find --arg addr YOUR_ADDRESS --arg file /tmp/search.log
```

### Информация о shared funds транзакции:
```bash
python3 main/client.py send --request wallet_shared_info --arg net KelVPN --arg tx TRANSACTION_HASH --arg H hex
```

## Доступные команды

### Сетевые операции:
- `version` - версия ноды
- `net_list` - список доступных сетей
- `net_get_id` - получить ID сети
- `net_get_status` - статус сети

### Операции с кошельком:
- `wallet_list` - список кошельков
- `wallet_info_w` - информация о кошельке по имени
- `wallet_info_addr` - информация о кошельке по адресу
- `wallet_outputs_w` - unspent outputs по имени кошелька
- `wallet_outputs_addr` - unspent outputs по адресу
- `wallet_find` - поиск кошелька по адресу
- `wallet_shared_info` - информация о shared funds

### Системные операции:
- `node_stats` - статистика CPU ноды
- `mempool_count` - количество транзакций в mempool
- `block_dump` - дамп блока

### Транзакции:
- `tx_create` - создание транзакции
- `tx_history_w` - история транзакций

## 🔗 Интеграция в пайплайн ноды

Этот CLI клиент может быть интегрирован в пайплайн сборки Cellframe Node для автоматического тестирования API и обеспечения обратной совместимости.

### Автоматическое тестирование:
```bash
# Установка ноды и запуск тестов
sudo ./install_and_test.sh cellframe-node-latest.deb

# Тестирование всех API методов
python3 test_node.py

# Тестирование конкретной версии API
python3 test_node.py --version v2
```

### Результаты тестирования:
- ✅ Валидация API v1 и v2
- ✅ Проверка обратной совместимости
- ✅ Автоматические отчеты в формате JSON
- ✅ Интеграция с GitLab CI/CD

📖 **Подробная документация по интеграции:** [INTEGRATION.md](INTEGRATION.md)
