# Устранение проблем интеграции

Этот документ содержит решения типичных проблем при интеграции CLI клиента в пайплайн ноды.

## 🚨 Типичные проблемы и решения

### 1. "No such file or directory" при поиске .deb файла

**Проблема:** 
```bash
dpkg: error: cannot access archive 'build_linux_rwd/build/cellframe-node-*.deb': No such file or directory
```

**Причина:** Неправильный путь к артефакту ноды

**Решение:**
```bash
# В джобе интеграции добавить отладку:
- echo "🔍 Поиск .deb файла ноды..."
- find . -name "*.deb" -type f | head -5
- NODE_DEB=$(find . -name "cellframe-node-*.deb" -type f | head -1)
- if [ -z "$NODE_DEB" ]; then echo "❌ .deb файл ноды не найден!"; exit 1; fi
- cp "$NODE_DEB" ./cellframe-node-latest.deb
```

### 2. "command not found: cellframe-node"

**Проблема:** Нода не установлена или не в PATH

**Решение:**
```bash
# Убедитесь что .deb файл устанавливается:
- dpkg -i cellframe-node-latest.deb || (apt-get install -f -y && dpkg -i cellframe-node-latest.deb)

# Проверьте установку:
- which cellframe-node || echo "cellframe-node не найден в PATH"
```

### 3. "Connection refused" при подключении к ноде

**Проблема:** Нода не запущена или не слушает правильный порт

**Решение:**
```bash
# Создайте конфигурацию перед запуском:
- mkdir -p /opt/cellframe-node/etc/
- |
  cat > /opt/cellframe-node/etc/cellframe-node.cfg << EOF
  [general]
  node_role=light
  debug_mode=true
  
  [server]
  enabled=true
  listen_address=127.0.0.1
  listen_port=12345
  
  [logging]
  log_level=INFO
  EOF

# Запустите ноду и дождитесь готовности:
- cellframe-node > node.log 2>&1 &
- |
  for i in {1..60}; do
    if curl -s http://127.0.0.1:12345/connect > /dev/null 2>&1; then
      echo "✅ Нода готова!"
      break
    fi
    sleep 1
    if [ $i -eq 60 ]; then
      echo "❌ Нода не запустилась"
      cat node.log
      exit 1
    fi
  done
```

### 4. Отсутствуют файлы в архиве CLI

**Проблема:** `install_and_test.sh` или `test_node.py` не найдены в архиве

**Решение:** Убедитесь что архив создается правильно:
```bash
# Проверьте содержимое архива:
- unzip -l cellframe-node-cli.zip | grep -E "\.(py|sh)$"

# Содержимое должно включать:
# - install_and_test.sh
# - test_node.py  
# - debug_integration.sh
# - main/client.py
# - main/validate.py
```

### 5. "No files to upload" для артефактов

**Проблема:** Директория `test_results/` не создается

**Решение:**
```bash
# В джобе убедитесь что тесты запускаются:
- python3 test_node.py --node-url http://127.0.0.1:12345/connect --output-dir test_results

# И что директория создается:
- ls -la test_results/ || echo "Директория test_results не создана"
```

## 🔧 Отладочный скрипт

Используйте `debug_integration.sh` для диагностики:

```bash
# В джобе интеграции добавьте:
- chmod +x debug_integration.sh
- ./debug_integration.sh
```

Скрипт проверит:
- ✅ Содержимое архива CLI
- ✅ Наличие .deb файла ноды  
- ✅ Системные зависимости
- ✅ Доступность ноды
- ✅ Ключевые файлы CLI

## 📋 Контрольный список для интеграции

### Перед интеграцией:
- [ ] Архив CLI содержит все необходимые файлы
- [ ] .deb файл ноды создается в джобе сборки
- [ ] Джоба интеграции зависит от джобы сборки ноды
- [ ] Образ Docker содержит все системные зависимости

### В джобе интеграции:
- [ ] Установлены: `python3 python3-pip python3-venv curl jq unzip wget`
- [ ] Архив CLI скачивается и распаковывается
- [ ] .deb файл ноды найден и скопирован
- [ ] Нода установлена и запущена
- [ ] Создан venv и установлены Python зависимости
- [ ] Запущены тесты с правильными параметрами

### После тестов:
- [ ] Созданы артефакты с результатами
- [ ] Нода корректно остановлена
- [ ] Логи сохранены для анализа

## 📞 Поддержка

### Просмотр логов ноды:
```bash
- cat node.log || echo "Лог файл ноды не найден"
```

### Проверка процессов:
```bash
- pgrep -fl cellframe || echo "Процессы cellframe не найдены"
- netstat -tlnp | grep :12345 || echo "Порт 12345 не прослушивается"
```

### Ручной запуск тестов:
```bash
- python3 test_node.py --help
- python3 test_node.py --command version
- python3 test_node.py --version v1 --output-dir manual_test
```

### Проверка зависимостей:
```bash
- python3 -c "import requests; import jsonschema; print('OK')"
```
