#!/bin/bash
# Скрипт отладки для интеграции с пайплайном ноды

set -e

echo "🔍 ОТЛАДКА ИНТЕГРАЦИИ CELLFRAME NODE CLI"
echo "========================================"

# 1. Проверка архива CLI
echo "1️⃣ Проверка содержимого архива CLI..."
if [ -f "cellframe-node-cli.zip" ]; then
    echo "✅ Архив найден"
    echo "📋 Содержимое архива:"
    unzip -l cellframe-node-cli.zip | grep -E "\.(py|sh|json)$" | head -10
    echo ""
else
    echo "❌ Архив cellframe-node-cli.zip не найден"
    exit 1
fi

# 2. Поиск .deb файла ноды
echo "2️⃣ Поиск .deb файла ноды..."
DEB_FILES=$(find . -name "*.deb" -type f 2>/dev/null || true)
if [ -n "$DEB_FILES" ]; then
    echo "✅ Найденные .deb файлы:"
    echo "$DEB_FILES"
    NODE_DEB=$(echo "$DEB_FILES" | grep cellframe-node | head -1)
    if [ -n "$NODE_DEB" ]; then
        echo "🎯 Выбран файл ноды: $NODE_DEB"
        echo "📊 Размер файла: $(du -h "$NODE_DEB" | cut -f1)"
    else
        echo "⚠️ cellframe-node .deb файл не найден среди:"
        echo "$DEB_FILES"
    fi
else
    echo "❌ .deb файлы не найдены"
    echo "🔍 Поиск в различных директориях:"
    find . -type d -name "*build*" 2>/dev/null || echo "   Директории build не найдены"
    find . -type d -name "*output*" 2>/dev/null || echo "   Директории output не найдены"
    find . -name "*cellframe*" -type f 2>/dev/null | head -5 || echo "   Файлы cellframe не найдены"
fi

echo ""

# 3. Проверка системы
echo "3️⃣ Проверка системных требований..."
echo "Python версия: $(python3 --version 2>/dev/null || echo 'НЕ УСТАНОВЛЕН')"
echo "pip версия: $(pip3 --version 2>/dev/null || echo 'НЕ УСТАНОВЛЕН')"
echo "curl: $(curl --version 2>/dev/null | head -1 || echo 'НЕ УСТАНОВЛЕН')"
echo "jq: $(jq --version 2>/dev/null || echo 'НЕ УСТАНОВЛЕН')"
echo "unzip: $(unzip -v 2>/dev/null | head -1 || echo 'НЕ УСТАНОВЛЕН')"
echo ""

# 4. Проверка доступности ноды
echo "4️⃣ Проверка доступности ноды..."
if curl -s --connect-timeout 5 http://127.0.0.1:12345/connect > /dev/null 2>&1; then
    echo "✅ Нода отвечает на http://127.0.0.1:12345/connect"
    echo "📡 Ответ ноды:"
    curl -s http://127.0.0.1:12345/connect | head -3 || echo "Ошибка получения ответа"
else
    echo "❌ Нода не отвечает на http://127.0.0.1:12345/connect"
    echo "🔍 Проверка процессов ноды:"
    pgrep -fl cellframe || echo "   Процессы cellframe не найдены"
    echo "🔍 Проверка портов:"
    netstat -tlnp 2>/dev/null | grep :12345 || echo "   Порт 12345 не прослушивается"
fi

echo ""

# 5. Проверка файлов CLI
echo "5️⃣ Проверка файлов CLI в архиве..."
if [ -f "cellframe-node-cli.zip" ]; then
    echo "🔍 Ключевые файлы:"
    unzip -l cellframe-node-cli.zip | grep -E "(test_node\.py|install_and_test\.sh|requirements\.txt|client\.py)" || echo "   Некоторые ключевые файлы отсутствуют"
fi

echo ""
echo "========================================"
echo "✅ Отладка завершена"
echo ""
echo "📝 РЕКОМЕНДАЦИИ:"
echo "1. Убедитесь что .deb файл ноды находится в правильной директории"
echo "2. Проверьте что архив CLI содержит все необходимые файлы"
echo "3. При проблемах с нодой - проверьте логи: tail -f node.log"
echo "4. Для ручного тестирования используйте: python3 test_node.py --help"
