import json
import sys
import os
import jsonschema

def validate_json(json_path, schema_path):
    try:
        with open(json_path, 'r') as f:
            instance = json.load(f)
        with open(schema_path, 'r') as f:
            schema = json.load(f)
        jsonschema.validate(instance=instance, schema=schema)
        print(f"✅ JSON is valid: {json_path}")
        return True
    except jsonschema.exceptions.ValidationError as e:
        print(f"❌ Validation error: {e.message}", file=sys.stderr)
        return False
    except Exception as e:
        print(f"❌ Error: {e}", file=sys.stderr)
        return False