#!/bin/bash
# Быстрый тест API ноды для CI/CD пайплайна

set -e
echo "🧪 Быстрый тест API Cellframe Node"
echo "=================================="

# Настройка
NODE_URL="http://127.0.0.1:12345/connect"
TEST_DIR="quick_test_results"
mkdir -p "$TEST_DIR"

# Функции
log_info() { echo "ℹ️ $1"; }
log_success() { echo "✅ $1"; }
log_error() { echo "❌ $1"; }

# Проверка доступности ноды
log_info "Проверка доступности ноды..."
if curl -s --connect-timeout 5 "$NODE_URL" > /dev/null 2>&1; then
    log_success "Нода отвечает на $NODE_URL"
else
    log_error "Нода не отвечает на $NODE_URL"
    exit 1
fi

# Установка зависимостей если нужно
if [ ! -d "venv" ]; then
    log_info "Создание виртуального окружения..."
    python3 -m venv venv
fi

source venv/bin/activate
pip install -r requirements.txt > /dev/null 2>&1

# Тест базовых команд
log_info "Тестирование команды version..."
if python3 test_node.py --command version --output-dir "$TEST_DIR" > /dev/null 2>&1; then
    log_success "Команда version работает"
else
    log_error "Команда version не работает"
fi

log_info "Тестирование команды net_list..."
if python3 test_node.py --command net_list --output-dir "$TEST_DIR" > /dev/null 2>&1; then
    log_success "Команда net_list работает"
else
    log_error "Команда net_list не работает"
fi

# Проверка результатов
log_info "Проверка результатов тестирования..."
if [ -d "$TEST_DIR" ] && [ "$(ls -A $TEST_DIR)" ]; then
    log_success "Результаты тестирования созданы:"
    ls -la "$TEST_DIR"
else
    log_error "Результаты тестирования не созданы"
    exit 1
fi

echo ""
echo "=================================="
log_success "Быстрый тест завершен успешно! 🎉"
echo "📁 Результаты: $(pwd)/$TEST_DIR"
